;; Copyright 2008 by Pere Pujal i Carabantes 
;; License GNU/GPL 
;; Author Pere Pujal i Carabantes 

(define (script-fu-index-selection 
         image 
         drawable 
         p-type 
         number-of-colors 
         palette 
         remove-unused 
         d-type 
         alpha-dither 
         ) 

  (let*( 
        (dither-type (list-ref '(0 1 2 3) d-type)) 
        (palette-type (list-ref '(0 2 3 4) p-type)) 
        (indeximage) 
        ) 
    (gimp-image-undo-group-start image) 
    (gimp-edit-copy drawable) 
    (set! indeximage (car (gimp-edit-paste-as-new))) 
    (gimp-image-convert-indexed indeximage  dither-type palette-type 
number-of-colors alpha-dither remove-unused palette ) 
    (gimp-image-convert-rgb indeximage) 
    (gimp-selection-all indeximage) 
    (gimp-edit-copy (car (gimp-image-get-active-layer indeximage))) 
    (gimp-floating-sel-anchor(car (gimp-edit-paste drawable 0))) 
    (gimp-image-delete indeximage) 
    (gimp-displays-flush) 
    (gimp-image-undo-group-end image) 
    )) 

(script-fu-register 
 "script-fu-index-selection" 
 "<Image>/Colors/Index Selection" 
 "Reduces the colors on the current selection." 
 "Pere Pujal i Carabantes" 
 "Copyright 2008" 
 "" 
 "" 
 SF-IMAGE "Image" 0 
 SF-DRAWABLE "Drawable" 0 
 SF-OPTION "Palette Type" '("MAKE-PALETTE" "WEB-PALETTE" "MONO-PALETTE" 
"CUSTOM-PALETTE") 
 SF-ADJUSTMENT "Number of Colors (ignored unless Palette 
type=MAKE-PALETTE)" '(255 2 256 1 25 0 0) 
 SF-PALETTE "Palette" "Web" 
 SF-TOGGLE "Remove unused (ignored if Palette type=MAKE-PALETTE)" FALSE 
 SF-OPTION "Dither type" '("NO-DITHER" "Floid Steinberg" "Floid 
Steinberg LowBleed" "FIXED") 
 SF-TOGGLE "Alpha Dither" FALSE 
 ) 
