#!/usr/bin/env python

# to_legacy_modes.py
# Created by Tin Tran http://gimplearn.net/
# Comments directed to http://gimplearn.net or http://gimp-forum.net or http://gimpchat.com or http://gimpscripts.com
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Rel 1: Initial release.
# Rel 2: Support layer groups but you must select an active layer that IS NOT a layergroup for script to run properly.
from gimpfu import *
import math
legacy_modes = ["LAYER-MODE-NORMAL-LEGACY","LAYER-MODE-DISSOLVE","LAYER-MODE-BEHIND-LEGACY","LAYER-MODE-MULTIPLY-LEGACY","LAYER-MODE-SCREEN-LEGACY","LAYER-MODE-OVERLAY-LEGACY","LAYER-MODE-DIFFERENCE-LEGACY","LAYER-MODE-ADDITION-LEGACY","LAYER-MODE-SUBTRACT-LEGACY","LAYER-MODE-DARKEN-ONLY-LEGACY","LAYER-MODE-LIGHTEN-ONLY-LEGACY","LAYER-MODE-HSV-HUE-LEGACY","LAYER-MODE-HSV-SATURATION-LEGACY","LAYER-MODE-HSL-COLOR-LEGACY","LAYER-MODE-HSV-VALUE-LEGACY","LAYER-MODE-DIVIDE-LEGACY","LAYER-MODE-DODGE-LEGACY","LAYER-MODE-BURN-LEGACY","LAYER-MODE-HARDLIGHT-LEGACY","LAYER-MODE-SOFTLIGHT-LEGACY","LAYER-MODE-GRAIN-EXTRACT-LEGACY","LAYER-MODE-GRAIN-MERGE-LEGACY","LAYER-MODE-COLOR-ERASE-LEGACY"]
new_modes = ["LAYER-MODE-OVERLAY","LAYER-MODE-LCH-HUE","LAYER-MODE-LCH-CHROMA","LAYER-MODE-LCH-COLOR","LAYER-MODE-LCH-LIGHTNESS","LAYER-MODE-NORMAL","LAYER-MODE-BEHIND","LAYER-MODE-MULTIPLY","LAYER-MODE-SCREEN","LAYER-MODE-DIFFERENCE","LAYER-MODE-ADDITION","LAYER-MODE-SUBTRACT","LAYER-MODE-DARKEN-ONLY","LAYER-MODE-LIGHTEN-ONLY","LAYER-MODE-HSV-HUE","LAYER-MODE-HSV-SATURATION","LAYER-MODE-HSL-COLOR","LAYER-MODE-HSV-VALUE","LAYER-MODE-DIVIDE","LAYER-MODE-DODGE","LAYER-MODE-BURN","LAYER-MODE-HARDLIGHT","LAYER-MODE-SOFTLIGHT","LAYER-MODE-GRAIN-EXTRACT","LAYER-MODE-GRAIN-MERGE","LAYER-MODE-VIVID-LIGHT","LAYER-MODE-PIN-LIGHT","LAYER-MODE-LINEAR-LIGHT","LAYER-MODE-HARD-MIX","LAYER-MODE-EXCLUSION","LAYER-MODE-LINEAR-BURN","LAYER-MODE-LUMA-DARKEN-ONLY","LAYER-MODE-LUMA-LIGHTEN-ONLY","LAYER-MODE-LUMINANCE","LAYER-MODE-COLOR-ERASE","LAYER-MODE-ERASE","LAYER-MODE-MERGE","LAYER-MODE-SPLIT","LAYER-MODE-PASS-THROUGH","LAYER-MODE-REPLACE","LAYER-MODE-ANTI-ERASE"]

def new_mode(legacymode): #converts for example: "LAYER-MODE-NORMAL-LEGACY" to "LAYER_MODE_NORMAL"
	return legacymode.replace("-","_").replace("_LEGACY","")

def legacy_mode(nmode): #converts for example: "LAYER-MODE-NORMAL" to "LAYER_MODE_NORMAL_LEGACY"
	return nmode.replace("-","_") + "_LEGACY"

#this is here because there seems to be a but with setting LAYER_MODE_OVERLAY_LEGACY
def legacy_mode_int(mode): #converts for example "LAYER_MODE_NORMAL_LEGACY" to integer(0)
	return legacy_modes.index(mode.replace("_","-"))
def new_mode_int(mode): #converts for example LAYER_MODE_NORMAL to integer
	return new_modes.index(mode.replace("_","-")) + 23

def change_mode_tt(currentlayer,legacy):#change mode recursively
	currentmode = currentlayer.mode
	#pdb.gimp_message(str(currentmode))
	if legacy == 1: #to new modes
		if currentmode < len(legacy_modes): #it's one of legacy modes
			newmode = new_mode(legacy_modes[currentmode])
			modeInt = new_mode_int(newmode)
			#runcode = "pdb.gimp_layer_set_mode(currentlayer," + newmode + ")"
			try:
				currentlayer.mode = modeInt
				#exec(runcode)
			except:
				message = "Layer '" + pdb.gimp_item_get_name(currentlayer) + "': failed setting new mode (" + newmode +")"
				pdb.gimp_message(message)
	elif legacy == 0: #back to legacy
		if currentmode >= 23: #it's one of new modes
			currentmode = currentmode - 23 #translation to array starting at 0
			newmode = legacy_mode(new_modes[currentmode])
			modeInt = legacy_mode_int(newmode)
			#runcode = "pdb.gimp_layer_set_mode(currentlayer," + str(modeInt) + ")"
			try:
				currentlayer.mode = modeInt
				#exec(runcode)
			except:
				message = "Layer '" + pdb.gimp_item_get_name(currentlayer) + "': failed setting new mode (" + newmode +")"
				pdb.gimp_message(message)
	#Loop through children and perform mode change as well recursively.
	for child in currentlayer.children:
		change_mode_tt(child,legacy)

def python_tt_to_legacy_modes(image, layer, legacy):
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	#pdb.gimp_selection_none(image)
	
	for currentlay in image.layers:
		change_mode_tt(currentlay,legacy)
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()
    #return

register(
	"python_fu_tt_to_legacy_modes",                           
	"Change layer modes to/from legacy modes",
	"Change layer modes to/from legacy modes",
	"Tin Tran",
	"Tin Tran",
	"July 2018",
	"<Image>/Tools/To Legacy Modes...",             #Menu path
	"RGB*, GRAY*", 
	[
	(PF_OPTION,"legacy",   "Legacy/New Modes", 0, ["To Legacy Modes","To New Modes"]),
	#(PF_SPINNER, "angle", "Rotate Angle (degrees):", 5.0, (-180, 180, 0.1)),
	#(PF_TOGGLE, "mirror",   "Mirror Edges:", 1),
	],
	[],
	python_tt_to_legacy_modes)

main()
