;;mhspheres
;Kiki
;http://kikidide.yuki-mura.net/GIMP/gimp.htm
;http://kikidide.yuki-mura.net/GIMP/engimp.htm
;
;ignore messages!
;

(define (script-fu-mhspheres img drawable x y z rad1 rad2 md cl1 cl2 bgm bg-color bgg bgp ft)
  (let* (


	 (width (car (gimp-drawable-width drawable)))
	 (height (car (gimp-drawable-height drawable)))


	 (grid1 (car (gimp-layer-new img width height RGBA-IMAGE "Grid1" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (grid2 (car (gimp-layer-new img width height RGBA-IMAGE "Grid2" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (bg (car (gimp-layer-new img width height RGB-IMAGE "BackGround" 100 LAYER-MODE-NORMAL-LEGACY)))

         (old-fg (car (gimp-palette-get-foreground)))
         (old-bg (car (gimp-palette-get-background)))
         (old-grad (car (gimp-gradients-get-active)))
         (old-pat (car (gimp-patterns-get-pattern)))
)
    (gimp-undo-push-group-start img)

    (gimp-image-resize img width height 0 0)
    (gimp-image-add-layer img grid1 0)
    (gimp-image-add-layer img grid2 2)
    (gimp-image-add-layer img bg 3)

    (gimp-selection-all img)
    (gimp-edit-clear bg)
    (gimp-edit-clear grid1)
    (gimp-edit-clear grid2)
    (gimp-selection-none img)

    (cond((= md 0)
	(plug-in-grid 1 img grid1 1 16 8 cl1 255 1 16 8 cl1 255 0 2 6 cl2 255)
	(gimp-rect-select img 0 0 (/ width 2) height 0 0 0)
	(gimp-edit-copy grid1)
	(gimp-edit-clear grid1)
	(gimp-floating-sel-anchor (car (gimp-edit-paste grid2 0))))
    ((= md 1)
	(gimp-palette-set-foreground cl1)
	(gimp-palette-set-background cl2)
	(plug-in-mosaic 1 img grid1 15 4 1 0.65 TRUE 135 0.2 TRUE TRUE 1 0 1)
	(gimp-rect-select img 0 0 (/ width 2) height 0 0 0)
	(gimp-edit-copy grid1)
	(gimp-edit-clear grid1)
	(gimp-floating-sel-anchor (car (gimp-edit-paste grid2 0))))
    ((= md 2)
	(gimp-palette-set-foreground cl1)
	(set! seed (rand 1138256384))
	(plug-in-maze 1 img grid1 5 5 TRUE 0 seed 57 1)
	(gimp-by-color-select grid1 '(255 255 255) 0 REPLACE TRUE FALSE 0 FALSE)
	(gimp-edit-clear grid1)
	(gimp-selection-none img)
	(gimp-rect-select img 0 0 (/ width 2) height 0 0 0)
	(gimp-edit-copy grid1)
	(gimp-edit-clear grid1)
	(gimp-floating-sel-anchor (car (gimp-edit-paste grid2 0)))
    ))

    (plug-in-map-object 1 img grid1 
			1  		; mapping
			0.5 0.5 2.0 	; viewpoint
			0.5 0.5 0.0 	; object pos
			1.0 0.0 0.0 	; first axis
			0.0 1.0 0.0 	; 2nd axis
			x y z 		; axis rotation
			0 '(255 255 255) 	; light (type, color)
			-0.5 -0.5 2 	; light position
			-1.0 -1.0 1.0 	; light direction
			0.3 1 0.5 0.3 27 	; material (amb, diff, refl, spec, high)
			TRUE 		; antialias
			FALSE 		; tile
			FALSE 		; new image
			TRUE 		; transparency(TRUE)
			rad1	 	; radius
			1 1 1 1 	; unused parameters
			0 0 0 0 0 0 0 0)
    (plug-in-map-object 1 img grid2 
			1  		; mapping
			0.5 0.5 2.0 	; viewpoint
			0.5 0.5 0.0 	; object pos
			1.0 0.0 0.0 	; first axis
			0.0 1.0 0.0 	; 2nd axis
			x y z 		; axis rotation
			0 '(255 255 255) 	; light (type, color)
			-0.5 -0.5 2 	; light position
			-1.0 -1.0 1.0 	; light direction
			0.3 1 0.5 0.3 27 	; material (amb, diff, refl, spec, high)
			TRUE 		; antialias
			FALSE 		; tile
			FALSE 		; new image
			TRUE 		; transparency
			rad1	 	; radius
			1 1 1 1 	; unused parameters
			0 0 0 0 0 0 0 0)
    (gimp-layer-set-opacity grid2 55)
    (gimp-layer-add-alpha drawable)
    (plug-in-map-object 1 img drawable 
			1  		; mapping
			0.5 0.5 2.0 	; viewpoint
			0.5 0.5 0.0 	; object pos
			1.0 0.0 0.0 	; first axis
			0.0 1.0 0.0 	; 2nd axis
			x y z		; axis rotation
			0 '(255 255 255) 	; light (type, color)
			-0.5 -0.5 2 	; light position
			-1.0 -1.0 1.0 	; light direction
			0.3 1 0.6 0.3 27 	; material (amb, diff, refl, spec, high)
			TRUE 		; antialias
			FALSE 		; tile
			FALSE 		; new image
			TRUE 		; transparency
			rad2	 	; radius
			1 1 1 1 	; unused parameters
			0 0 0 0 0 0 0 0)


    (gimp-palette-set-foreground bg-color)
    (gimp-drawable-fill bg FILL-FOREGROUND)
    (cond((= bgm 1)
       (gimp-gradients-set-active bgg) 
       (gimp-blend bg BLEND-CUSTOM LAYER-MODE-NORMAL-LEGACY GRADIENT-LINEAR 100 20 REPEAT-NONE FALSE 0 0 0 0 0 0 0 height))
    ((= bgm 2)
       (gimp-selection-all img)
       (gimp-patterns-set-pattern bgp)
       (gimp-bucket-fill bg BUCKET-FILL-PATTERN LAYER-MODE-NORMAL-LEGACY 100 255 FALSE 0 0)
       (gimp-selection-none img)
       ))

    (if (= ft TRUE) (gimp-image-flatten img))

    (gimp-palette-set-foreground old-fg)
    (gimp-palette-set-background old-bg)
    (gimp-gradients-set-active old-grad)
    (gimp-patterns-set-pattern old-pat)

    (gimp-undo-push-group-end img)
    (gimp-displays-flush)
))

(script-fu-register "script-fu-mhspheres"
		    "<Image>/Script-Fu/MH/spheres"
		    "mhspheres"
		    "Kiki"
		    "Kiki"
		    "2006/1"
		    "RGB*"
		    SF-IMAGE		"Image"		0
		    SF-DRAWABLE		"Drawable"	0
		    SF-ADJUSTMENT	"Rotation x"	'(-20 -40 40 1 2 0 0)
		    SF-ADJUSTMENT	"Rotation y"	'(-75 -120 -60 1 2 0 0)
		    SF-ADJUSTMENT	"Rotation z"	'(10 0 30 1 2 0 0)
		    SF-ADJUSTMENT	"radius"	'(0.40 0.01 0.5 0.05 0.5 2 0)
		    SF-ADJUSTMENT	"inner radius"	'(0.30 0.01 0.5 0.05 0.5 2 0)
                    SF-OPTION		"mode"		'(_"grid" _"mosaic" _"maze")
		    SF-COLOR		"Color1"	'(0 0 128)
		    SF-COLOR		"Color2"	'(0 0 255)
                    SF-OPTION		"bg mode"	'(_"color" _"grad" _"pattern")
		    SF-COLOR		"Background Color"	'(255 255 233)
                    SF-GRADIENT		"Background Gradient"	"Browns"
                    SF-PATTERN		"Background Pattern"	"Rain"
                    SF-TOGGLE		"Flatten Image"	TRUE
)
