;;mhrealtama
;Kiki
;http://kikidide.yuki-mura.net/GIMP/gimp.htm
;http://kikidide.yuki-mura.net/GIMP/engimp.htm
;
;ignore messages!
;

(define (script-fu-mhrealtama radius hue vpro bg-color ref usef? ft)
  (let* ((img (car (gimp-image-new 256 256 RGB)))

         (width (* radius 2))

	 (bg-layer (car (gimp-layer-new img width width RGB-IMAGE "Background" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (drawable (car (gimp-layer-new img width width RGBA-IMAGE "drawable" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (red (car (gimp-layer-new img width width RGBA-IMAGE "red" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (glow (car (gimp-layer-new img width width RGBA-IMAGE "glow" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (hilight (car (gimp-layer-new img width width RGBA-IMAGE "hilight" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (hilight2 (car (gimp-layer-new img width width RGBA-IMAGE "hilight2" 100 LAYER-MODE-NORMAL-LEGACY)))
	 (hilight3 (car (gimp-layer-new img width width RGBA-IMAGE "hilight3" 100 LAYER-MODE-NORMAL-LEGACY)))

	 (ref-img (car (gimp-file-load 1 ref ref)))
	 (ref-layer (car (gimp-image-get-active-drawable ref-img)))
	 (reflect (car (gimp-layer-new img width width RGBA-IMAGE "reflect" 100 LAYER-MODE-NORMAL-LEGACY)))

         (old-fg (car (gimp-palette-get-foreground)))
         (old-grad (car (gimp-gradients-get-gradient)))
         (old-pat (car (gimp-patterns-get-pattern)))
)
    (gimp-image-undo-disable img)

    (gimp-image-resize img width width 0 0)
    (gimp-image-add-layer img bg-layer 0)
    (gimp-image-add-layer img drawable 0)
    (gimp-image-add-layer img red 0)
    (gimp-image-add-layer img glow 0)
    (gimp-image-add-layer img hilight 0)
    (gimp-image-add-layer img hilight2 0)
    (gimp-palette-set-foreground bg-color)
    (gimp-edit-fill bg-layer FILL-FOREGROUND)
    (gimp-selection-all img)
    (gimp-edit-clear drawable)
    (gimp-edit-clear red)
    (gimp-edit-clear glow)
    (gimp-edit-clear hilight)
    (gimp-edit-clear hilight2)

    (gimp-ellipse-select img (- (/ width 2) (/ radius 2)) (- (/ width 2) (/ radius 2)) radius radius CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-palette-set-foreground '(35 10 0))
    (gimp-edit-fill drawable FILL-FOREGROUND)
    (gimp-palette-set-foreground '(193 51 1))
    (gimp-edit-fill red FILL-FOREGROUND)
    (gimp-selection-grow img (/ radius 10))
    (gimp-selection-translate img (/ radius 3) (/ radius 3))
    (gimp-selection-feather img (/ radius 2.5))
    (gimp-selection-invert img)
    (gimp-edit-clear red)
    (gimp-layer-set-mode red LAYER-MODE-SCREEN-LEGACY)
    (gimp-layer-set-opacity red 50)

    (gimp-ellipse-select img (- (/ width 2) (/ radius 2)) (- (/ width 2) (/ radius 2)) radius radius CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-selection-shrink img (/ radius 40))
    (if (< radius 2) (set! radius 1))
    (gimp-selection-feather img (/ radius 20))
    (gimp-palette-set-foreground '(237 63 0))
    (gimp-edit-fill glow FILL-FOREGROUND)
    (gimp-image-resize img (* width 2) (* width 2) (/ width 2) (/ width 2))
    (gimp-ellipse-select img (- (/ width 2) (/ radius 2)) (- (/ width 2) (/ radius 2)) (* 3 radius) (* 3 radius) CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-selection-shrink img (/ radius 40))
    (gimp-selection-feather img (/ radius 20))
;;    (gimp-selection-grow img radius)
    (gimp-selection-translate img (* radius 1.345) (* radius 1.345))
    (gimp-image-resize img width width (/ width -2) (/ width -2))
    (gimp-selection-feather img (/ radius 20))
    (gimp-selection-invert img)
    (gimp-edit-clear glow)
    (gimp-layer-set-opacity glow 55)
    (gimp-selection-none img)

(define (copy-layer-realtama dest-image dest-drawable source-image source-drawable)
  (gimp-selection-all dest-image)
  (gimp-edit-clear dest-drawable)
  (gimp-selection-none dest-image)
  (gimp-selection-all source-image)
  (gimp-edit-copy source-drawable)
      (let ((floating-sel (car (gimp-edit-paste dest-drawable FALSE))))
	(gimp-floating-sel-anchor floating-sel))
)
    (gimp-image-add-layer img reflect 3)  		;Ԃς
    (copy-layer-realtama img reflect ref-img ref-layer)
    (gimp-image-delete ref-img)
    (plug-in-map-object 1 img reflect 
			     1		 ; mapping
			     0.5 0.5 2.0 ; viewpoint
			     0.5 0.5 0.0 ; object pos
			     1.0 0.0 0.0 ; first axis
			     0.0 1.0 0.0 ; 2nd axis
			     0.0 0.0 0.0 ; axis rotation
			     0 '(255 255 255)	; light (type, color)
			     -0.5 -0.5 2.0	; light position
			     -1.0 -1.0 1.0	; light direction
			     0.3 1.0 0.5 0.0 27.0 ; material (amb, diff, refl, spec, high)
			     TRUE	 ; antialias
			     FALSE	 ; tile
			     FALSE	 ; new image
			     FALSE	 ; transparency
			     0.25	 ; radius
			     1.0 1.0 1.0 1.0 ; unused parameters
			     0 0 0 0 0 0 0 0)
    (gimp-ellipse-select img (- (/ width 2) (/ radius 2)) (- (/ width 2) (/ radius 2)) radius radius CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-selection-invert img)
    (gimp-edit-clear reflect)

    (gimp-image-resize img (* width 2) (* width 2) (/ width 2) (/ width 2))
    (gimp-ellipse-select img (* radius 2) radius (* radius 2) (* radius 2) CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-selection-feather img (/ radius 5))
    (gimp-edit-clear reflect)
    (gimp-ellipse-select img radius (* radius 2.3) (* radius 2) (* radius 2) CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-selection-feather img (/ radius 5))
    (gimp-edit-clear reflect)
    (gimp-image-resize img width width (/ width -2) (/ width -2))
    (gimp-layer-set-mode reflect SCREEN-MODE)
    (gimp-layer-set-opacity reflect 45)

    (gimp-ellipse-select img (+ (* radius 0.65) (/ radius 10)) (+ (* radius 0.57) (/ radius 10)) (/ radius 17) (/ radius 17) CHANNEL-OP-REPLACE TRUE 0 0)
    (gimp-palette-set-foreground '(255 255 255))
    (gimp-selection-feather img (/ radius 25))
    (gimp-edit-fill hilight2 FILL-FOREGROUND)
    (gimp-selection-none img)
;    (plug-in-gauss-iir2 1 img hilight2 (/ radius 25) (/ radius 25))
    (gimp-layer-set-mode hilight2 LAYER-MODE-SCREEN-LEGACY)

    (if (= usef? TRUE)
    (begin
	(gimp-selection-all img)
	(gimp-palette-set-foreground '(0 0 0))
	(gimp-edit-fill hilight FILL-FOREGROUND)
	(gimp-selection-none img)
	(gimp-layer-set-opacity hilight 70)
	(plug-in-flarefx 1 img hilight (+ (* radius 0.68) (/ radius 10)) (+ (* radius 0.60) (/ radius 10)))
	(gimp-ellipse-select img (* radius 0.68) (* radius 0.60) (/ radius 5) (/ radius 5) CHANNEL-OP-REPLACE TRUE 0 0)
	(gimp-selection-feather img (/ radius 10))
	(gimp-selection-invert img)
	(gimp-edit-clear hilight)
	(gimp-selection-none img)
    ))

    (if (= usef? FALSE)
    (begin
	(gimp-image-add-layer img hilight3 0)
	(gimp-edit-clear hilight3)
	(gimp-selection-layer-alpha hilight2)
	(gimp-palette-set-foreground '(255 255 255))
	(gimp-selection-feather img (/ radius 10))
	(gimp-edit-fill hilight FILL-FOREGROUND)
	(gimp-edit-fill hilight3 FILL-FOREGROUND)
	(gimp-selection-none img)
	(gimp-layer-resize hilight3 (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    ))

    (gimp-hue-saturation drawable 0 hue vpro 0)
    (gimp-hue-saturation red 0 hue vpro 0)
    (gimp-hue-saturation glow 0 hue vpro 0)
    (gimp-hue-saturation hilight 0 hue vpro 0)


    (gimp-image-resize img (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize bg-layer (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize drawable (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize red (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize glow (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize reflect (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize hilight (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-layer-resize hilight2 (/ width 1.5) (/ width 1.5) (/ width -6) (/ width -6))
    (gimp-image-set-active-layer img hilight2)

    (if (= ft TRUE) (gimp-image-flatten img))

    (gimp-palette-set-foreground old-fg)
    (gimp-gradients-set-gradient old-grad)
    (gimp-patterns-set-pattern old-pat)

    (gimp-image-undo-enable img)
    (gimp-display-new img)
))

(script-fu-register "script-fu-mhrealtama"
		    "<Toolbox>/Xtns/Script-Fu/MHPattern/realtama"
		    "mhrealtama"
		    "Kiki"
		    "Kiki"
		    "2005/4"
		    ""
                    SF-ADJUSTMENT  _"radius"       '(300 20 1000 1 2 0 0)
		    SF-ADJUSTMENT   "hue"	  '(0 -180 180 1 2 0 0)
		    SF-ADJUSTMENT   "value"  '(0 -100 100 1 2 0 0)
		    SF-COLOR        "Background Color" '(119 81 68)
		    SF-FILENAME    _"Environment Map" (string-append "" gimp-data-dir "/scripts/images/beavis.jpg")
                    SF-TOGGLE       "Use flare?(it takes time)"  FALSE
                    SF-TOGGLE       "Flatten Image?"  FALSE
)
