#!/usr/bin/env python
#
from gimpfu import *

def save_to_files(image, layer, outputFolder):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    
    try:
        
        # Save as JPEG
        gimp.pdb.file_jpeg_save(image, layer, outputFolder + "/" + "cover" + ".jpg", "raw_filename", 0.90, 0, 0, 1, "USER", 3, 0, 0, 0)
        gimp.pdb.gimp_image_clean_all(image)
        
    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "python_fu_test_save_to_files",
    "Save to files",
    "Save the current layer into a JPEG file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/Save to jpeg",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
    ],
    [],
    save_to_files)

main()
