;; save-layers-tiff.scm
;;
;; Save individual layers of a multi-layer image as a set of TIFF
;; files, named like file0000.tif.  
;;
;;   Copyright (C) 2006 J.D. Smith <jdsmith@as.arizona.edu>
;;
;; Version 1.0 (Oct, 2006)
;;  
;; Based on the Perl-Fu script of Krisztian Rassay <debian@freemail.hu>
;; 
;##############################################################################
; 
; LICENSE
;
;  save-layers-tiff is free software; you can redistribute it and/or
;  modify it under the terms of the GNU General Public License as
;  published by the Free Software Foundation; either version 2, or (at
;  your option) any later version.
;  
;  save-layers-tiff is distributed in the hope that it will be useful,
;  but WITHOUT ANY WARRANTY; without even the implied warranty of
;  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;  General Public License for more details.
;  
;  You should have received a copy of the GNU General Public License
;  along with save-layers-tiff; see the file COPYING.  If not, write
;  to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
;  Floor, Boston, MA 02110-1301, USA.
;
;##############################################################################

(define (script-fu-save-layers-tiff img draw)
  (let* ((filename (car (gimp-image-get-filename img)))
	 (file-base (unbreakupstr (butlast (strbreakup filename ".")) "."))
	 (img-layers (gimp-image-get-layers img))
	 (num-layers (car img-layers))
	 (layers (cadr img-layers))
 	 (cnt 0)
	 (layer nil)
	 (layer-file-name nil)
         (mask nil))
    (gimp-image-undo-group-start img)
    (while (< cnt num-layers)
	   (set! layer (aref layers cnt))
	   (set! mask (car (gimp-layer-get-mask layer)))
	   (if (not (= mask -1))
	       (gimp-layer-remove-mask layer MASK-APPLY))
	   (gimp-layer-resize-to-image-size layer) ;; resize
	   (set! layer-file-name 
		 (string-append file-base (number->string cnt 10 4) ".tif"))
	   (file-tiff-save 1 img layer layer-file-name layer-file-name 1)
	   (set! cnt (+ cnt 1)))
    (gimp-image-undo-group-end img)))

(apply script-fu-register
       (append 
	(list
	 "script-fu-save-layers-tiff"
	 _"Save Layers as Individual Files"
	 _"Save the layers of the current image as individual files.")
	(list "J.D. Smith <jdsmith@as.arizona.edu>"
	    "J.D. Smith"
	    "2006")
	(list
	 "RGB* GRAY*"
	 SF-IMAGE      _"IMAGE"             0
	 SF-DRAWABLE    "(unused) Drawable" 0)))

(script-fu-menu-register 
 "script-fu-save-layers-tiff"
 _"<Image>/Script-Fu/Utils/")


