; https://bazz1.wordpress.com/2015/07/23/gimp-script-fu-color-to-alpha-all-layers/

(define (script-fu-colortoalpha-all-layers inImg inColor)
    (let* ( (x (cadr (gimp-image-get-layers inImg) ) ) 
                    (y (car (gimp-image-get-layers inImg) ) )
                    (i 0)
                ) 
 
                (do ((i 0 (+ i 1)))
                    ((= i y) i)  
                    (plug-in-colortoalpha 1 inImg (vector-ref x i) inColor))
    )
 
)
 
  (script-fu-register
    "script-fu-colortoalpha-all-layers"                           ;func name
    "color-to-alpha All Layers"                                   ;menu label
    "Map a color to transparent for all layers"                   ;description
    "Michael Bazzinotti"                                          ;author
    "copyright 2015, Michael Bazzinotti;"                         ;copyright notice
    "December 8, 2014"                                            ;date created
    "RGB, RGBA, GRAY, GRAYA"                                      ;image type that the script works on
    SF-IMAGE      "Image"         0                               ;
    SF-COLOR      "Color"         '(255 255 255)                  ;color variable, white
  )
  (script-fu-menu-register "script-fu-colortoalpha-all-layers" "<Image>/Image")
