from gimpfu import *
import pygtk
import gtk
from sys import argv, platform
from ctypes import *
#import sys
#sys.stderr = open('C:/temp/python-fu-output.txt','a')
#sys.stdout=sys.stderr # So that they both go to the same file

def load_library (library_name):
    if platform == "linux" or platform == "linux2":
        library_name = library_name + '.so.0'
    elif platform == "win32":
        from ctypes.util import find_library
        library_name = find_library (library_name + "-0")
    else:
        raise BaseException ("TODO")
    return CDLL (library_name)
#import sys
#print (sys.version)
gimp = load_library ('libgimp-2.0')
#print (gimp)
#gimp = load_library ('libgimp-3.0')

def use_gegl_graph(image, drawable, gegl_graph_string):
    class GeglBuffer(Structure):
        pass
    drawable_id = drawable.ID
    
    gegl = load_library ('libgegl-0.4')
    sucess = gegl.gegl_init (None, None)
    gimp.gimp_drawable_get_shadow_buffer.restype = POINTER (GeglBuffer)
    gimp.gimp_drawable_get_buffer.restype        = POINTER (GeglBuffer)

    x = c_int (); y = c_int (); w = c_int (); h = c_int ()
    non_empty,x,y,w,h = pdb.gimp_drawable_mask_intersect (drawable)
    args = [b"string", c_char_p (gegl_graph_string), c_void_p ()]
    
    if non_empty:
        source = gimp.gimp_drawable_get_buffer (drawable_id)
        target = gimp.gimp_drawable_get_shadow_buffer (drawable_id)
        sucess = gegl.gegl_render_op (source, target, "gegl:gegl", *args)
        gegl.gegl_buffer_flush (target)
        gimp.gimp_drawable_merge_shadow (drawable_id, PushUndo = True)
        gimp.gimp_drawable_update (drawable_id, x, y, w, h)
        gimp.gimp_displays_flush ()


def for_gegl_command(image, drawable):
# put your GEGL command here
# saturation scale minimum value 0  max value 10
    gegl_graph_string="saturation scale=10 colorspace=0"
    use_gegl_graph(image, drawable,gegl_graph_string)

    pdb.gimp_displays_flush(image)

# menu registration
register(
    "python_fu_for_gegl_command",
    "Use GEGL command",
    "Do GEGL command",
    "",
    "",
    "",
    "Do GEGL command", 
    "RGB*",
    [
      (PF_IMAGE,      "image",       "Input image", None),
      (PF_DRAWABLE,   "drawable", "Input drawable", None)
    ],
    [],
    for_gegl_command,
    menu="<Image>/Tools/gegl command/"
    )

main()
