#!/usr/bin/env python2
from ctypes import *
from sys import argv, platform


def load_library (library_name):
    if platform == "linux" or platform == "linux2":
        library_name = library_name + '.so.0'
    elif platform == "win32":
        from ctypes.util import find_library
        library_name = find_library (library_name + "-0")
    else:
        raise BaseException ("TODO")

    return CDLL (library_name)
#import sys
#print (sys.version)
gimp = load_library ('libgimp-2.0')
#print (gimp)
#gimp = load_library ('libgimp-3.0')

class GimpParamData (Union):
    _fields_ = [ ('d_float'   , c_double),
                 ('d_string'  , c_char_p),
                 ('d_color'   , c_double * 4),
                 ('d_drawable', c_int),
                 ('d_status'  , c_int) ]

class GimpParam (Structure):
    _fields_ = [ ('type', c_int),
                 ('data', GimpParamData) ]

GimpRunProc = CFUNCTYPE (None,
                         c_char_p,
                         c_int,
                         POINTER (GimpParam),
                         POINTER (c_int),
                         POINTER (POINTER (GimpParam)))

void_FUNC_void = CFUNCTYPE (None)

class GimpPlugInInfo (Structure):
    _fields_ = [ ('init_proc', void_FUNC_void),
                 ('quit_proc', void_FUNC_void),
                 ('query_proc', void_FUNC_void),
                 ('run_proc', GimpRunProc) ]
    def __init__ (self,
                  query_proc,
                  run_proc,
                  init_proc = void_FUNC_void (),
                  quit_proc = void_FUNC_void ()):
        Structure.__init__ (self)
        self.init_proc  = init_proc
        self.quit_proc  = quit_proc
        self.query_proc = query_proc
        self.run_proc   = run_proc

class GimpParamDef (Structure):
    _fields_ = [ ('type', c_int),
                 ('name', c_char_p),
                 ('description', c_char_p) ]

GimpParam2 = GimpParam * 2
ret_values = GimpParam2 ()

def run (proc_name, n_params, params, n_return_vals, return_vals):
    class GeglBuffer(Structure):
        pass

    return_vals[0] = ret_values
    ret_values[0].type = 21 # GIMP_PDB_STATUS

    drawable = params[0].data.d_drawable
    if gimp.gimp_item_is_group (drawable) or gimp.gimp_item_is_vectors (drawable):
        n_return_vals[0] = 2

        ret_values[0].data.d_status = 1 # GIMP_PDB_CALLING_ERROR

        ret_values[1].type          = 4 # GIMP_PDB_STRING
        ret_values[1].data.d_string = b"filter " + proc_name + b" called on a layer-group/vectors item"
        return

    n_return_vals[0] = 1
    ret_values[0].data.d_status = 3  # GIMP_PDB_SUCCESS

    gegl = load_library ('libgegl-0.4')

    gegl.gegl_init (None, None)

    gimp.gimp_drawable_get_shadow_buffer.restype = POINTER (GeglBuffer)
    gimp.gimp_drawable_get_buffer.restype        = POINTER (GeglBuffer)

    std_dev  = c_double (params[1].data.d_float)
    contrast = c_double (params[2].data.d_float)

    x = c_int (); y = c_int (); w = c_int (); h = c_int ()
    if gimp.gimp_drawable_mask_intersect (drawable, byref (x), byref (y), byref (w), byref (h)):
        source = gimp.gimp_drawable_get_buffer (drawable)
        target = gimp.gimp_drawable_get_shadow_buffer (drawable)

        gegl.gegl_render_op (source, target, proc_name,
                             b"std-dev"  , std_dev,
                             b"contrast" , contrast,
                             c_void_p ())

        gegl.gegl_buffer_flush (target)
        gimp.gimp_drawable_merge_shadow (drawable, PushUndo = True)
        gimp.gimp_drawable_update (drawable, x, y, w, h)
        gimp.gimp_displays_flush ()


def query ():
    params = [ GimpParamDef ( 16, b'layer', b'Input layer'),
               GimpParamDef (  3, b'std-dev', b'Std deviation (radius =~ 3 std-dev) Range is [0 5000.0]'),
               GimpParamDef (  3, b'contrast', b'Contrast Range is [0.0 5.0]') ]
    GimpParamDefN = GimpParamDef * len (params)

    gimp.gimp_install_procedure (b"gegl:high-pass",         # name
                                 b"Invokes gegl:high-pass", # blurb
                                 b"Runs gegl:high-pass",    # help
                                 b"drawoC suomynonA",       # author
                                 b"Public Domain",          # copyright
                                 b"2018",                   # date
                                 b"Gegl High Pass",         # menu_label
                                 b"*",                      # image_types
                                 1,                         # GimpPDBProcType type GIMP_PLUGIN == 1
                                 len (params),              # n_params
                                 0,                         # n_return_vals
                                 GimpParamDefN (*params),   # params
                                 None)


PLUG_IN_INFO = GimpPlugInInfo (void_FUNC_void (query), GimpRunProc (run))

Argc = len (argv)

charArrayN = c_char_p * Argc
Argv = charArrayN (*[ai.encode ('utf8') for ai in argv])

#print ("Here")
gimp.gimp_main (byref (PLUG_IN_INFO), Argc, Argv)
