#!/usr/bin/env python

# colour_tone.py
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Version 1 03/12/2021
# 
#
#
#import Image
from gimpfu import *
import gimpcolor
def python_colour_tone(image, layer, colour) :
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	base_type = pdb.gimp_image_base_type(image)												#check if RGB or GRAY	
	
	if base_type == GRAY:

		pdb.gimp_image_convert_rgb(image)													#if greyscale image convert to RGB
		Desaturate = pdb.gimp_layer_new_from_drawable(layer,image)							#make new layer to be named "Desaturate" (source, destination)
		pdb.gimp_image_insert_layer(image,Desaturate,None,0)								#(image, layer, parent, position)
	else:
	
		Desaturate = pdb.gimp_layer_new_from_drawable(layer,image)							#make new layer to be named "Desaturate" (source, destination)
		pdb.gimp_image_insert_layer(image,Desaturate,None,0)								#(image, layer, parent, position)
		pdb.gimp_drawable_desaturate(Desaturate,DESATURATE_LUMINANCE)						#(drawable, destination)
		
	pdb.gimp_item_set_name(Desaturate,"Desaturate")											#name the layer				
	#Tone = pdb.gimp_layer_new_from_drawable(Desaturate,image)								#copy "Desaturate" to Tone (source, destination)
	#pdb.gimp_image_insert_layer(image,Tone,None,0)											#(image, layer, parent, position)
	#pdb.gimp_item_set_name(Tone,"Tone")													#name the layer
	
	width   = image.width
	height  = image.height
	type    = RGB_IMAGE
	opacity = 100
	mode    = NORMAL_MODE
	
	Tone = pdb.gimp_layer_new(image, width, height, type, "Tone", opacity, mode)			#new empty layer
	image.add_layer(Tone, 0)

	
	if colour == 0:
	
		sepia = gimpcolor.RGB(211,66,20)
		pdb.gimp_context_set_foreground(sepia)
		
	elif colour == 1:	
	
		brick = gimpcolor.RGB(200,30,10)
		pdb.gimp_context_set_foreground(brick)
		
	elif colour == 2:	
	
		blue = gimpcolor.RGB(2,51,252)
		pdb.gimp_context_set_foreground(blue)
		
	elif colour == 3:	
	
		red = gimpcolor.RGB(238,64,30)
		pdb.gimp_context_set_foreground(red)
		
	elif colour == 4:	
	
		green = gimpcolor.RGB(31,211,28)
		pdb.gimp_context_set_foreground(green)
	
	
	pdb.gimp_drawable_edit_fill(Tone, FILL_FOREGROUND)
	
	pdb.gimp_layer_set_mode(Tone, LAYER_MODE_SOFTLIGHT)
		
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()


register(
	"python_colour_tone",
	"Colour Tone",
	"Colour Tone",
	"David Marsden",
	"David Marsden",
	"December 2021",
	"<Image>/Python-Fu/Colour Tone...",             						#Menu path
	"RGB*, GRAY*", 
	[
	  (PF_OPTION, "colour", "Colour", 0, ("Sepia", "Brick", "Blue", "Red", "Green")),
	],
	[],
	python_colour_tone)

main()
