;This script duplicates a vector object (path), and rotates it
;the amount of duplicates is defined by the user
;The script rotate each path so the final result will be a circle of paths
;For the latest version, email me at <lightningismyname@gmail.com>


(define (script-fu-duplicate-rotate-vector-do-it2 img rotated_copies center center-x center-y)

     (let* (

		(count 0)

		(vector 0)

		(vector_position 0)

		(vector_name 0)

		(vector_new 0)

		(strokes 0)

		(strokes_count 0)

		(points 0)

		(points_num 0)

		(open 0) 

		(angle (/ 360 rotated_copies))

		(stroke_new 0)

     )
	

	;undo group
	(gimp-image-undo-group-start img)

	(if (= center 0)
	(begin

		(set! center-x (/ (car(gimp-image-width img)) 2))

		(set! center-y (/ (car(gimp-image-height img)) 2))

	))

	(while (> (- rotated_copies 1) 0)
	(begin

		(set! count 0)

		(set! vector (car(gimp-image-get-active-vectors img)))

		(set! vector_position (car(gimp-image-get-vectors-position img vector)))

		(set! vector_name (car(gimp-vectors-get-name vector)))

		(set! strokes (cadr(gimp-vectors-get-strokes vector)))

		(set! strokes_count (car(gimp-vectors-get-strokes vector)))

		(set! points (caddr(gimp-vectors-stroke-get-points vector (aref strokes count))))

		(set! points_num (cadr(gimp-vectors-stroke-get-points vector (aref strokes count))))

		(set! open (cadddr(gimp-vectors-stroke-get-points vector (aref strokes count)))) 


	(set! vector_new (car(gimp-vectors-new img vector_name)))

	(gimp-image-add-vectors img vector_new vector_position)

	(set! stroke_new (car(gimp-vectors-stroke-new-from-points vector_new 0 points_num points open)))

	(gimp-vectors-stroke-rotate vector_new stroke_new center-x center-y angle)

	(while (< (+ count 1) strokes_count)
	(begin

		(set! count (+ 1 count))

		(set! points (caddr(gimp-vectors-stroke-get-points vector (aref strokes count))))

		(set! points_num (cadr(gimp-vectors-stroke-get-points vector (aref strokes count))))

		(set! open (cadddr(gimp-vectors-stroke-get-points vector (aref strokes count)))) 

		(set! stroke_new (car(gimp-vectors-stroke-new-from-points vector_new 0 points_num points open)))

		(gimp-vectors-stroke-rotate vector_new stroke_new center-x center-y angle)
	))

		(gimp-vectors-set-linked vector_new (car(gimp-vectors-get-linked vector)))

		(gimp-vectors-set-visible vector_new (car(gimp-vectors-get-visible vector)))

		(gimp-image-set-active-vectors img vector_new)

	(set! rotated_copies (- rotated_copies 1))
	))

	;end of undo group
	(gimp-image-undo-group-end img)

))



(define (script-fu-duplicate-rotate-vector2 img rotated_copies center center-x center-y)

     (let* (

		(vector (car(gimp-image-get-active-vectors img)))

		(strokes_count)

		

     )
	

	;undo group
	(gimp-image-undo-group-start img)

	(if (= -1 vector)
	(gimp-message "Your image has no paths in it! This script only works on paths") )

	(if (not(= -1 vector))
	(begin
		(set! strokes_count (car(gimp-vectors-get-strokes vector)))
	
		(if (= 0 strokes_count)
		(gimp-message "Nothing to rotate! Your active path is empty - it has no points in it!") )

		(if (not(= 0 strokes_count))
		(script-fu-duplicate-rotate-vector-do-it2 img rotated_copies center center-x center-y) )
	))

	;end of undo group
	(gimp-image-undo-group-end img)

))


(script-fu-register
      "script-fu-duplicate-rotate-vector2"
              	"<Image>/Shapes/Duplicate and Rotate a path..."
              	"Duplicates the active vector, Sets it in the position above the original vector and sets it as active. If no strokes exist in the vector or if no vector exists an error is returned"
              	"LightningIsMyName (LIMN)"
              	"LightningIsMyName (LIMN)"
		"March 2008"
              	""
		SF-IMAGE	"Image"     0
;		SF-DRAWABLE	"Drawable (Unused)"  0
		SF-ADJUSTMENT	"How many copies in total? (Rotation=360/copies)"         '(6 1 360 1 1 0 1)
		SF-OPTION	"Center of rotation"				'("Automatic - Center of the Image" "As specified below")
		SF-VALUE	"X-Center of Rotation" "0"
		SF-VALUE	"Y-Center of Rotation" "0"


)

