#!/usr/bin/env python
# -*- coding: utf-8 -*-

# search_replace_layer_names
# Ver1.1
# Created by stigzler
# Comments directed to magoarcade.com
# Credit to xenoid, SatckOverflow for help
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# V1.0: Initial release.
# V1.1: Added Group/Layer rename toggles + layer start.
 
import math
import string
import re
import traceback
from gimpfu import *
from array import array
 
def python_search_replace_layer_names(image, layer, searchterm, replaceterm, applyvisible, casesensative, startlevel,renamegroups,renamelayers) :
 
	pdb.gimp_image_undo_group_start(image)
	
	try:
		if casesensative == 0:
			searchtermRegEx = re.compile(re.escape(searchterm),re.IGNORECASE)
		else:
			searchtermRegEx = re.compile(re.escape(searchterm))				
		renameLayers(image,startlevel,searchtermRegEx,replaceterm,applyvisible,renamegroups,renamelayers)	
 
	except Exception as e:
		trace(e.args[0])
		gimp.message(e.args[0]+':'+traceback.format_exc())	
		
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()
 
def renameLayers(parent,level,searchtermRegEx,replaceterm,applyvisible,renamegroups,renamelayers):
 
	for pos,layerOrGroup in enumerate(parent.layers):
		if (applyvisible == 0) or (layerOrGroup.visible != 0):
		
			#if isinstance(layerOrGroup,gimp.GroupLayer) and (renamegroups == 1) :
			if isinstance(layerOrGroup,gimp.GroupLayer) :
				if (renamegroups == 1) :
					layerName = searchtermRegEx.sub(replaceterm, layerOrGroup.name)
					layerOrGroup.name = layerName
			
			elif isinstance(layerOrGroup,gimp.Layer) and (renamelayers == 1) :
				layerName = searchtermRegEx.sub(replaceterm, layerOrGroup.name)
				layerOrGroup.name = layerName
			
		if isinstance(layerOrGroup,gimp.GroupLayer):
			renameLayers(layerOrGroup,level+1,searchtermRegEx,replaceterm,applyvisible,renamegroups,renamelayers)
 
register(
	"search-replace-layer-names",
	"Search/Replace in Layer Names...",
	"Search/Replace in Layer Names...",
	"stigzler",
	"stigzler",
	"2020",
	"Replace Layer Names...",
	"*", 
	[
	(PF_IMAGE,"image", "Image:", None),
	(PF_DRAWABLE, "drawable", "Drawable:", None),
	(PF_STRING, "searchterm", "Search for Term:", "SearchTerm"),
	(PF_STRING, "replaceterm", "Replace With:", "ReplaceWith"),
	(PF_TOGGLE, "applyvisible",   "Only Apply to visible layers:   ", 0),
	(PF_TOGGLE, "casesensative",   "Case sensative:", 0),
	(PF_SPINNER, "startlevel",   "Start Level:", 0, (0,100000,1)),
	(PF_TOGGLE, "renamegroups",   "Rename Groups:", 1),
	(PF_TOGGLE, "renamelayers",   "Rename Layers:", 1)
	],
	[],
	python_search_replace_layer_names,
	menu="<Image>/Edit/Search and Replace/"
)
 
main()
