;
; The GIMP -- an image manipulation program
; Copyright (C) 1995 Spencer Kimball and Peter Mattis
;
; Mass edit layers attributes script  for GIMP 2.4
; Created by Daniel Bates
;
; Tags: public domain, layers, edit, attributes
;
; Author statement:
;
; Script designed to edit layer attributes for the specified layer range
; Layer name, mode, opacity, visible, linked and alpha lock can all be optionally set
;
; --------------------------------------------------------------------
; Distributed by Gimp FX Foundry project
; --------------------------------------------------------------------
;   - Changelog -
;
; 2021/11/23 Patrice Laborda (PixLab) update to take in count all layer's modes of GIMP 2.10.x (not only legacy) and few visual other things
;
; --------------------------------------------------------------------
;
; This script is released into the public domain.
; You may redistribute and/or modify this script or extract segments without prior consent.

; This script is distributed in the hope of being useful
; but without warranty, explicit or otherwise.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


; Define Script

(define (script-fu-modify-layers-attributes theImage theDraw theLayer1 theLayer2 ENcheck theLayerName ELMcheck theLayerMode EOcheck theLayerOpacity EVcheck theLayerVisible ELcheck theLayerLink EMTcheck theLayerMT)

; Define Variables

(let*
(
    (theNumber 0)
    (theRepeat 0)
    (theName 0)
    (theLayerRef 0)
 )


; If the end layer is set below the start layer create an error message and terminate
(if (> theLayer1 theLayer2)
(begin
(set! theLayerRef (car (gimp-message-get-handler)))
(gimp-message-set-handler 0)
(gimp-message "Error: End layer number must be set higher than start layer number!")
(gimp-message-set-handler theLayerRef))
(begin

; Begin an undo group
(gimp-image-undo-group-start theImage)

; Get the number of layers in an image and set to a variable
(set! theNumber (car (gimp-image-get-layers theImage)))

; If layer2 is set above total layers change layer2 value to the total number of layers
(if (> theLayer2 theNumber)
(set! theLayer2 theNumber))

; Set the repeat variable by subtracting the user input values from the total number of layers
(set! theRepeat (+ (- theLayer2 theLayer1) 1))

; Adjust the value received for layer mode for direct input
(if (> theLayerMode 1)
(set! theLayerMode (+ theLayerMode 1)))

; Adjust the value received for visible for direct input
(if (= theLayerVisible 0)
(set! theLayerVisible 1)
(set! theLayerVisible 0))

; Set up variable for setting active layers and attributes
(set! theLayerRef (cadr (gimp-image-get-layers theImage)))

; Alter theNumber for use in setting active layers and attributes
(set! theNumber (- theNumber (- theLayer1 1)))

; Begin loop and continue while repeat is higher than zero
(while (> theRepeat 0)

    ; Edit layer name if requested by the user
    (if (= ENcheck TRUE)
    (gimp-drawable-set-name (aref theLayerRef (- theNumber 1)) (string-append theLayerName "#1")))

    ; Edit layer mode if requested by the user
    (if (= ELMcheck TRUE)
    (gimp-layer-set-mode (aref theLayerRef (- theNumber 1)) theLayerMode))

    ; Edit opacity if requested by the user
    (if (= EOcheck TRUE)
    (gimp-layer-set-opacity (aref theLayerRef (- theNumber 1)) theLayerOpacity))

    ; Edit layer visible property if requested by the user
    (if (= EVcheck TRUE)
    (gimp-drawable-set-visible (aref theLayerRef (- theNumber 1)) theLayerVisible))

    ; Edit linked property if requested by the user
    (if (= ELcheck TRUE)
    (gimp-drawable-set-linked (aref theLayerRef (- theNumber 1)) theLayerLink))

    ; Edit maintain transparency property if requested by the user
    (if (= EMTcheck TRUE)
    (gimp-layer-set-lock-alpha (aref theLayerRef (- theNumber 1)) theLayerMT))

    ; Alter variables ready for checking for next layer and applying to next layer
    ; (set! theLayer (+ theLayer 1))
    (set! theNumber (- theNumber 1))
    (set! theRepeat (- theRepeat 1))

)

; Update visual display
(gimp-displays-flush)

; End undo group
(gimp-image-undo-group-end theImage)

))
))

; Register script
(script-fu-register     "script-fu-modify-layers-attributes"
            _"Edit Multiple Layers Attributes..."
            _"Chose a layers range then edits layers' attributes within that layers range at once"
            "Daniel Bates"
            "Daniel Bates"
            "Dec 2007"
            "*"
            SF-IMAGE "SF-IMAGE" 0
            SF-DRAWABLE "SF-DRAWABLE" 0
            SF-ADJUSTMENT _"Start at which layer? (1 = bottom/BG layer)" '(1 1 2000 1 5 0 0)
            SF-ADJUSTMENT _"End at which layer?" '(50 1 2000 1 5 0 0)
            SF-TOGGLE _"Edit Layer Name?" FALSE
            SF-STRING "New Layer Name" "Layer"
            SF-TOGGLE _"Edit layer modes?" TRUE
            SF-OPTION _"New Layer Mode" '(_"LAYER-MODE-NORMAL-LEGACY (0)" _"LAYER-MODE-DISSOLVE (1)" _"LAYER-MODE-MULTIPLY-LEGACY (3)" _"LAYER-MODE-SCREEN-LEGACY (4)" _"LAYER-MODE-OVERLAY-LEGACY (5)" _"LAYER-MODE-DIFFERENCE-LEGACY (6)" _"LAYER-MODE-ADDITION-LEGACY (7)" _"LAYER-MODE-SUBTRACT-LEGACY (8)" _"LAYER-MODE-DARKEN-ONLY-LEGACY (9)" _"LAYER-MODE-LIGHTEN-ONLY-LEGACY (10)" _"LAYER-MODE-HSV-HUE-LEGACY (11)" _"LAYER-MODE-HSV-SATURATION-LEGACY (12)" _"LAYER-MODE-HSL-COLOR-LEGACY (13)" _"LAYER-MODE-HSV-VALUE-LEGACY (14)" _"LAYER-MODE-DIVIDE-LEGACY (15)" _"LAYER-MODE-DODGE-LEGACY (16)" _"LAYER-MODE-BURN-LEGACY (17)" _"LAYER-MODE-HARDLIGHT-LEGACY (18)" _"LAYER-MODE-SOFTLIGHT-LEGACY (19)" _"LAYER-MODE-GRAIN-EXTRACT-LEGACY (20)" _"LAYER-MODE-GRAIN-MERGE-LEGACY (21)" _"LAYER-MODE-COLOR-ERASE-LEGACY (22)" _"LAYER-MODE-OVERLAY (23)" _"LAYER-MODE-LCH-HUE (24)" _"LAYER-MODE-LCH-CHROMA (25)" _"LAYER-MODE-LCH-COLOR (26)" _"LAYER-MODE-LCH-LIGHTNESS (27)" _"LAYER-MODE-NORMAL (28)" _"LAYER-MODE-BEHIND (29)" _"LAYER-MODE-MULTIPLY (30)" _"LAYER-MODE-SCREEN (31)" _"LAYER-MODE-DIFFERENCE (32)" _"LAYER-MODE-ADDITION (33)" _"LAYER-MODE-SUBTRACT (34)" _"LAYER-MODE-DARKEN-ONLY (35)" _"LAYER-MODE-LIGHTEN-ONLY (36)" _"LAYER-MODE-HSV-HUE (37)" _"LAYER-MODE-HSV-SATURATION (38)" _"LAYER-MODE-HSL-COLOR (39)" _"LAYER-MODE-HSV-VALUE (40)" _"LAYER-MODE-DIVIDE (41)" _"LAYER-MODE-DODGE (42)" _"LAYER-MODE-BURN (43)" _"LAYER-MODE-HARDLIGHT (44)" _"LAYER-MODE-SOFTLIGHT (45)" _"LAYER-MODE-GRAIN-EXTRACT (46)" _"LAYER-MODE-GRAIN-MERGE (47)" _"LAYER-MODE-VIVID-LIGHT (48)" _"LAYER-MODE-PIN-LIGHT (49)" _"LAYER-MODE-LINEAR-LIGHT (50)" _"LAYER-MODE-HARD-MIX (51)" _"LAYER-MODE-EXCLUSION (52)" _"LAYER-MODE-LINEAR-BURN (53)" _"LAYER-MODE-LUMA-DARKEN-ONLY (54)" _"LAYER-MODE-LUMA-LIGHTEN-ONLY (55)" _"LAYER-MODE-LUMINANCE (56)" _"LAYER-MODE-COLOR-ERASE (57)" _"LAYER-MODE-ERASE (58)" _"LAYER-MODE-MERGE (59)" _"LAYER-MODE-SPLIT (60)")
            SF-TOGGLE _"Edit opacity?" FALSE
            SF-ADJUSTMENT _"New Opacity" '(100 0 100 1 10 0 0)
            SF-TOGGLE _"Edit visible property?" FALSE
            SF-OPTION _"New Visible Property" '(_"Show Layers" _"Hide Layers")
            SF-TOGGLE _"Edit linked property?" FALSE
            SF-OPTION _"New Linked Property" '(_"Unlink Layers" _"Link Layers")
            SF-TOGGLE _"Lock Alpha channel (lock transparency)?" FALSE
            SF-OPTION _"Lock Alpha Channel?" '(_"No" _"Yes")
)

(script-fu-menu-register "script-fu-modify-layers-attributes"
                         "<Image>/Layer/Multi-Layer Tools")

