#!/usr/bin/env python
##########################################################################
#
#  pastexy.py           --  Paste the  clipboard at location X,Y
#
##########################################################################
#
#  Copyright 2010 by Floyd L. Davidson, floyd@apaflo.com
#  File created:  Sun Dec  5 11:33:44 2010
#  Last updated:  Mon Dec  6 04:51:17 2010
#
##########################################################################
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#
##########################################################################

from gimpfu import *

def python_pastexy(image, layer, x, y, rotate, zoom, flat, name):

    def paste_xy(name, x, y):
        pdb.gimp_selection_all(image)
        original_layer = pdb.gimp_image_get_active_layer(image)
        clipbrd = pdb.gimp_layer_copy(original_layer, True)
        pdb.gimp_image_add_layer(image, clipbrd, -1)
        pdb.gimp_image_set_active_layer(image, clipbrd)
        pdb.gimp_edit_clear(clipbrd)
        wrklayer = pdb.gimp_edit_paste(clipbrd, True)
        pdb.gimp_floating_sel_anchor(wrklayer)
        clipbrd  = pdb.gimp_image_get_active_layer(image)
        pdb.plug_in_autocrop_layer(image, clipbrd)

        if rotate != 0:
            pdb.gimp_selection_all(image)
            clipbrd  = pdb.gimp_image_get_active_layer(image)
            r = math.radians(rotate)
            centerx = clipbrd.width  / 2

            centery = clipbrd.height / 2

            wrklayer = pdb.gimp_drawable_transform_rotate_default(clipbrd, r, 1, centerx, centery, 1, 0)
            clipbrd  = pdb.gimp_image_get_active_layer(image)

        clipbrd  = pdb.gimp_image_get_active_layer(image)
        x1 = clipbrd.width
        y1 = clipbrd.height

        realzoom = math.sqrt(zoom)

        if zoom > 1.05:
            y1 = y1 * realzoom
            x1 = x1 * realzoom
            pdb.gimp_layer_scale(clipbrd, x1, y1, True)

        if zoom < 0.95:
            y1 = y1 * realzoom
            x1 = x1 * realzoom
            pdb.gimp_layer_scale(clipbrd, x1, y1, True)

        offset_x, offset_y = pdb.gimp_drawable_offsets(clipbrd)

        pdb.gimp_layer_translate(clipbrd, x - offset_x, y - offset_y)
        pdb.gimp_layer_resize_to_image_size(clipbrd)
        clipbrd  = pdb.gimp_image_get_active_layer(image)
        pdb.gimp_drawable_set_name(clipbrd, name)

        if rotate != 0:
            pdb.gimp_image_remove_layer(image, wrklayer)

        if flat == True:
            pdb.gimp_image_flatten(image)
#
#  Process image
#
    image.undo_group_start()
    paste_xy(name, x, y)
    image.undo_group_end()

register(
        "python_fu_pastexy",
        N_("Paste Clipboard at location X,Y"),
        """Paste Clipboard into new layer at location X,Y""",
        "Floyd Davidson",
        "GPL",
        "2010",
        N_("New Layer at location X,Y"),
        "*",
        [
          (PF_IMAGE,    "image",    "Input image",           None),
          (PF_DRAWABLE, "layer",    "Input drawable",        None),
          (PF_INT,      "x",        "Horizontal Coordinate", 0),
          (PF_INT,      "y",        "Vertical Coordinate",   0),
          (PF_INT,      "rotate",   "Rotate +/- degrees",    0),
          (PF_FLOAT,    "zoom",     "Zoom",                  1.00),
          (PF_BOOL,     "flat",     "Flatten Image?",        False),
          (PF_STRING,   "name",     "Name of New Layer",     "Clipboard Object"),
        ],
        [],
        python_pastexy,
        menu="<Image>/Edit/Paste as",
        domain=("gimp20-python", gimp.locale_directory))

main()
