; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

(define (sg-layers-apply-masks image drawable)
  (let* (
      (layer's (vector->list (cadr (gimp-image-get-layers image))))
      )
    (gimp-image-undo-group-start image)
    (while (pair? layer's)
      (when (and (= (car (gimp-drawable-get-visible (car layer's))) TRUE)
                 (<> (car (gimp-layer-get-mask (car layer's))) -1))
        (gimp-layer-remove-mask (car layer's) MASK-APPLY)
        (gimp-layer-set-lock-alpha (car layer's) TRUE)
        )
      (set! layer's (cdr layer's))
      )
    )
  (gimp-image-undo-group-end image)
  (gimp-displays-flush)
  )

(script-fu-register "sg-layers-apply-masks"
  "Apply masks on visible layers"
  "On visible layers, apply each layer's mask"
  "Saul Goode"
  "Saul Goode"
  "11/16/2009"
  "*"
  SF-IMAGE    "Image"    0
  SF-DRAWABLE "Drawable" 0
  )
(script-fu-menu-register "sg-layers-apply-masks"
                         "<Layers>")      
(script-fu-menu-register "sg-layers-apply-masks"
                         "<Image>/Layer/Mask")
