#!/usr/bin/env python

# col-cast-reduction.py
# Created by David Marsden
#
# Based on Krikor-color-cast-reduction
# Created by Tin Tran https://gimplearn.net
#
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Version 1: 26/07/2022
# Version 2: 27/07/2022 Copy orig layer into new RGB layer and delete original
#						to eliminate any alpha channel.
#
from gimpfu import *

def python_col_cast_reduction(image,layer):
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	layer_copy2 = pdb.gimp_layer_new(image,layer.width,layer.height,RGB_IMAGE,'Image',100,LAYER_MODE_NORMAL)	# new layer RGB mode - lose original alpha channel
	pdb.gimp_image_insert_layer(image,layer_copy2,None,0)
	pdb.gimp_selection_all(image)																				# select original image
	pdb.gimp_edit_copy(layer)																					# copy to buffer
	pdb.gimp_selection_none(image)																				# remove selection
	floating_sel = pdb.gimp_edit_paste(layer_copy2,FALSE)														# paste into new RGB layer
	pdb.gimp_floating_sel_anchor(floating_sel)																	# anchor
	pdb.gimp_image_remove_layer(image, layer)																	# remove original layer
		
	layer_copy = pdb.gimp_layer_new_from_drawable(layer_copy2,image)											# new layer to derive average colour
	pdb.gimp_image_insert_layer(image,layer_copy,None,0)
	layerName = "Colour"
	pdb.gimp_item_set_name(layer_copy, layerName)	
	pdb.plug_in_pixelize2(image,layer_copy,layer_copy.width,layer_copy.height)									# blur pixelize with image width and image height	
	pdb.gimp_drawable_invert(layer_copy,FALSE) 																	# colors - invert FALSE for Linear	
	pdb.gimp_layer_set_mode(layer_copy,LAYER_MODE_OVERLAY)														# layer mode to overlay
	
	layer_copy1 = pdb.gimp_layer_new_from_drawable(layer_copy2,image)											# add layer to become contrast mask
	pdb.gimp_image_insert_layer(image,layer_copy1,None,0)	
	pdb.gimp_drawable_desaturate(layer_copy1,DESATURATE_LUMINANCE)												# desaturate layer	
	pdb.gimp_layer_set_mode(layer_copy1,LAYER_MODE_OVERLAY)														# overlay mode	
	pdb.gimp_layer_set_opacity(layer_copy1, 50.0)																# opacity will change contrast
	layerName = "Contrast"
	pdb.gimp_item_set_name(layer_copy1, layerName)

		
	pdb.gimp_image_set_active_layer(image, layer_copy1)															# make contrast layer active
	
	
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()

register(
	"python_fu_col_cast_reduction",
	"Col Cast Reduction",
	"Col Cast Reduction",
	"David Marsden",
	"David Marsden",
	"July 2022",
	"<Image>/Python-Fu/Col Cast Reduction...",             														#Menu path
	"RGB*, GRAY*, INDEXED*", 
	[],
	[],
	python_col_cast_reduction)

main()
