#!/usr/bin/env python
#
from gimpfu import *
import time

def quick_save(image, layer, outputFolder, save_jpeg):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    name=pdb.gimp_layer_get_name(layer)
    ticks = str(time.time())
    pdb.gimp_item_set_name(layer, name + ticks)

    
    try:
 
        if save_jpeg == 1:
                pdb.file_jpeg_save(image, layer, outputFolder + "/" + layer.name + ".jpg", "raw_filename", 0.85, 0, 0, 1, "rich", 3, 0, 0, 0)

        else:
                pdb.file_png_save(image, layer,outputFolder + "/" + layer.name + ".png","raw_filename",0,9,0,0,0,0,0)

        pdb.gimp_item_set_name(layer, name)        
        pdb.gimp_image_clean_all(image)

    except Exception as err:
        message("Unexpected error: " + str(err))
    
register(
    "python_fu_test_save_to_png",
    "Save to files",
    "Save the current layer into a jpeg/png file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/Quick_Save",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
        (PF_TOGGLE,   "save_jpeg",   "save_jpeg",   True),
    ],
    [],
    quick_save)

main()
