#!/usr/bin/env python
#
from gimpfu import *
import time

def save_to_xcf(image, drawable, outputFolder):

    gimp.progress_init("Saving to '" + outputFolder + "'...")
    name=pdb.gimp_image_get_name(image)
    ticks = str(time.time())

    
    try:
        
        # Save as xcf
        pdb.gimp_xcf_save(0, image, drawable, name + ticks + ".xcf","raw_filename")
        pdb.gimp_image_clean_all(image)

    except Exception as err:
        gimp.message("Unexpected error: " + str(err))
    
register(
    "python_fu_test_save_to_xcf",
    "Save to files",
    "Save image as xcf file",
    "RG",
    "Open source",
    "2013",
    "<Image>/Tools/Save to xcf",
    "*",
    [
        (PF_DIRNAME, "outputFolder", "Output directory", ""),
    ],
    [],
    save_to_xcf)

main()
