#!/usr/bin/env python
# -*- coding: utf-8 -*-

# svg-gradients Rel 8
# Created by Tin Tran
# Comments directed to http://gimpchat.com or http://gimpscripts.com
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
#
# ------------
#| Change Log |
# ------------
# Rel 1: Initial release.
# Rel 2: Took out a gimp_message that i used for debugging
# Rel 3: Make valid svg file with rectangle drawn so that the .svg gradient file can also be opened in GIMP.
# Rel 4: Moved location of functions to Right Clicking Gradients
# Rel 5: Changed backward slash (\) to forward slash so that it'll work in Linux as well, not sure can't test it because i am on windows, asking Rich to test for me
# Rel 6: missed a backward slash setting, changed to forward slash
# Rel 7: Changed code so that gradient_folder is defined in one place instead of 4 places.
# Rel 8: Use os.path.join instead of hardcoding slashes as suggested by Dinasset
from gimpfu import *
import os, string, sys

#where gradient folder is located, the ~ will be expanded by calling os.path.expanduser() function later
#gradient_folder = "~/.gimp-2.8/gradients/";
#gradient_folder = os.path.join("~",".gimp-2.8","gradients","") #as suggested by dinasset to not hardcode slashes.

gradient_folder = os.path.join(gimp.directory, "gradients", "")

gradient_names = [];
def get_svg_gradient_names():
	global gradient_names;
	gradient_names = [];
	dirname = gradient_folder
	dirname = os.path.expanduser(dirname)
	for filename in os.listdir(dirname):
		found = filename.find('.svg')
		if  found > -1:
			gradient_name = filename[0:found]      #extract gradient name
			gradient_names.append(gradient_name);  #add it to select list
	return gradient_names

def color_to_hex(color):
	whole_color = (color[0],color[1],color[2]);
	#pdb.gimp_message(str(color[3]));
	#pdb.gimp_message(color[0]);
	#pdb.gimp_message(color[1]);
	#pdb.gimp_message(color[2]);
	return '#%02x%02x%02x' % whole_color
#creates a new svg gradient by defining color at 0% stop color and opacity and 100% stop color and opacity
def tt_new_svg_gradient(gradient_name,new_gradient_name,start_color,start_opacity,end_color,end_opacity):
	#pdb.gimp_message("new gradient:" + str(gradient_name))
	gradient_name = new_gradient_name
	newfilename = gradient_folder + gradient_name + ".svg"
	newfilename = os.path.expanduser(newfilename)
	newfile = open( u''+newfilename,'w' )
	newfile.write('<svg width="640" height="480" version="1.1" xmlns="http://www.w3.org/2000/svg">\n')
	newfile.write('<defs>\n')
	newfile.write('<linearGradient id="' + gradient_name + '">\n')
	#pdb.gimp_message(str(start_color));
	newfile.write('<stop offset="0%" stop-color="'+ color_to_hex(start_color) +'" stop-opacity="'+str(start_opacity/100.0)+'" />\n')
	newfile.write('<stop offset="100%" stop-color="'+ color_to_hex(end_color) +'" stop-opacity="'+str(end_opacity/100.0)+'" />\n')
	newfile.write('</linearGradient>\n')
	newfile.write('</defs>\n')
	newfile.write('<rect x="0" y="0" width="640" height="480" fill="url(#' + gradient_name + ')"/>\n');
	newfile.write('</svg>\n')
	newfile.close();
	pdb.gimp_gradients_refresh();

def is_valid_svg(heads):
	first_line = heads[0]
	found = first_line.find('<svg')
	if found > -1:
		return True
	return False

#returns altered heads and tails when given gradient_name
def valid_svg_heads_tails(heads,tails,gradient_name):
	if not is_valid_svg(heads):
		new_heads = ['<svg width="640" height="480" version="1.1" xmlns="http://www.w3.org/2000/svg">\n'] + heads
		new_tails = tails + ['<rect x="0" y="0" width="640" height="480" fill="url(#' + gradient_name + ')"/>\n','</svg>\n']
		return new_heads,new_tails
	return heads,tails #if we get here we just return the same values unaltered because it is already valid svg

def getKey(item):
	return item[0]
#>>> l = [[2, 3], [6, 7], [3, 34], [24, 64], [1, 43]]
#>>> sorted(l, key=getKey)
#[[1, 43], [2, 3], [3, 34], [6, 7], [24, 64]]
def tt_add_svg_gradient_stop(gradient_name,stop_at,stop_color,stop_opacity):
	#pdb.gimp_message("add gradient g:" + str(g))
	#gradient_name = gradient_names[gradient]; #grab gradient name from our populated list of files

	filename = gradient_folder + gradient_name + ".svg"
	filename = os.path.expanduser(filename)
	file = open( u''+filename,'r' )

	#read all lines into list of lines
	lines = file.readlines()
	file.close();

	found_stops = False;
	is_stop = False;
	heads = []
	stops = []
	tails = []

	#puts data in our arrays heads,stops,tails
	for line in lines:
		found = line.find('<stop offset="');
		if found > -1:
			found_stops = True;
			is_stop = True;
		else:
			is_stop = False;
		if not is_stop:
			if not found_stops:
				heads.append(line);
			else:
				tails.append(line);
		else: #is stop
			stops.append(line);

	#check and see if svg is valid if not make it valid
	heads,tails = valid_svg_heads_tails(heads,tails,gradient_name)

	#add our stop before we grab keys and sort them to write back to file.
	stops.append('<stop offset="'+ str(int(stop_at)) +'%" stop-color="'+ color_to_hex(stop_color) +'" stop-opacity="'+str(stop_opacity/100.0)+'" />\n')

	#put stops in keyed array in order to sort stops
	sorted_stops = []
	for stop in stops:
		start = stop.find('<stop offset="') + 14;
		end = stop.find('%',start);
		key = int(stop[start:end])
		sorted_stops.append([key,stop])


	#sorts the stops using key which is stop's offset percentage
	sorted_stops = sorted(sorted_stops, key=getKey);

	#write back to file
	file = open( u''+filename,'w' )
	for head in heads:
		file.write(head);
	for stop in sorted_stops:
		file.write(stop[1]);
	for tail in tails:
		file.write(tail);

	file.close();


	pdb.gimp_gradients_refresh();



def tt_delete_svg_gradient_stop_range(gradient_name,stop_start,stop_end):
	#pdb.gimp_message("delete gradient g:" + str(g))
	#gradient_name = gradient_names[gradient]; #grab gradient name from our populated list of files

	filename = gradient_folder + gradient_name + ".svg"
	filename = os.path.expanduser(filename)
	file = open( u''+filename,'r' )

	#read all lines into list of lines
	lines = file.readlines()
	file.close();

	found_stops = False;
	is_stop = False;
	heads = []
	stops = []
	tails = []

	#puts data in our arrays (heads,stops,tails) heads will contain all lines before defining stops,
	#stops will contain lines that define stops, and tail will contain everything after that
	for line in lines:
		found = line.find('<stop offset="');
		if found > -1:
			found_stops = True;
			is_stop = True;
		else:
			is_stop = False;
		if not is_stop:
			if not found_stops:
				heads.append(line);
			else:
				tails.append(line);
		else: #is stop
			stops.append(line);

	#check and see if svg is valid if not make it valid
	heads,tails = valid_svg_heads_tails(heads,tails,gradient_name)

	#put stops in keyed array in order to sort stops
	sorted_stops = []
	for stop in stops:
		start = stop.find('<stop offset="') + 14;
		end = stop.find('%',start);
		key = int(stop[start:end])
		if (key < stop_start) or (key > stop_end): #if it's outside of defined range we keep it
			sorted_stops.append([key,stop])

	if len(sorted_stops) == 0: #if there is no stop we add one stop just as place holder
		sorted_stops.append([0,'<stop offset="0%" stop-color="#ffffff" stop-opacity="1.0" />\n'])

	#sorts the stops using key which is stop's offset percentage
	sorted_stops = sorted(sorted_stops, key=getKey);

	#write back to file
	file = open( u''+filename,'w' )
	for head in heads:
		file.write(head);
	for stop in sorted_stops:
		file.write(stop[1]);
	for tail in tails:
		file.write(tail);

	file.close();


	pdb.gimp_gradients_refresh();

register(
    "python_fu_new_svg_gradient",
    "Creates a new SVG gradient file",
    "Creates a new SVG gradient file...",
    "Tin Tran",
    "GPL",
    "2016",
    "<Gradients>/SVG/New...",
    "",
    [
    #(PF_IMAGE, "image", "Input image", None), #current image
    #(PF_DRAWABLE, "layer", "Input layer", None), #current layer
    #(PF_FILENAME, "curvefilename","Curfile", dircurve ),
	(PF_STRING, "gradient_name", "hidden not used:", "SVG Gradient 001"),
    (PF_STRING, "new_gradient_name", "New SVG Gradient Name:", "SVG Gradient 001"),
    (PF_COLOR, "start_color", "Start Color:", (0, 0, 0) ),
    (PF_SLIDER, "start_opacity", "Start Opacity:", 100, (0, 100, 1)),
    (PF_COLOR, "end_color", "End Color:", (255,255,255)),
    (PF_SLIDER, "end_opacity", "End Opacity:", 100, (0, 100, 1)),
	#(PF_OPTION,"presetid",   "Color Curves Preset:", 0, local_get_color_curves_presets_names()), # initially 0th is choice
	#(PF_INT, "presetid", "Color Curves Preset Id:", 0),
    ],
    [],
    tt_new_svg_gradient)
register(
    "python_fu_add_svg_gradient_stop",
    "Adds a new stop to svg gradient file",
    "Adds a new stop to svg gradient file...",
    "Tin Tran",
    "GPL",
    "2016",
    "<Gradients>/SVG/Add a Stop...",
    "",
    [
    #(PF_IMAGE, "image", "Input image", None), #current image
    #(PF_DRAWABLE, "layer", "Input layer", None), #current layer
    #(PF_FILENAME, "curvefilename","Curfile", dircurve ),
    #(PF_OPTION,"gradient",   "SVG Gradient Name:", 0, get_svg_gradient_names()),
	(PF_STRING, "gradient_name", "hidden not used:", "injected by gimp"),
	(PF_SLIDER, "stop_at", "Stop At Percentage:", 50, (0, 100, 1)),
    (PF_COLOR, "stop_color", "Stop Color:", (128,128,128)),
    (PF_SLIDER, "stop_opacity", "Stop Opacity:", 100, (0, 100, 1)),
    #(PF_STRING, "gradient_name", "New SVG Gradient Name:", "SVG Gradient 001"),
    #(PF_COLOR, "start_color", "Start Color:", (0, 0, 0) ),
    #(PF_SLIDER, "start_opacity", "Start Opacity:", 1, (0, 100, 1)),
    #(PF_COLOR, "end_color", "End Color:", (255,255,255)),
    #(PF_SLIDER, "end_opacity", "End Opacity::", 1, (0, 100, 1)),
	#(PF_OPTION,"presetid",   "Color Curves Preset:", 0, local_get_color_curves_presets_names()), # initially 0th is choice
	#(PF_INT, "presetid", "Color Curves Preset Id:", 0),
    ],
    [],
    tt_add_svg_gradient_stop)
register(
    "python_fu_delete_svg_gradient_stop_range",
    "Deletes all stops within range of svg gradient file",
    "Deletes all stops within range of svg gradient file...",
    "Tin Tran",
    "GPL",
    "2016",
    "<Gradients>/SVG/Delete Stops within Range...",
    "",
    [
    #(PF_OPTION, "gradient",   "SVG Gradient Name:", 0, get_svg_gradient_names()),
	(PF_STRING, "gradient_name", "hidden not used:", "injected by gimp"),
    (PF_SLIDER, "stop_start", "Delete Stop Start Percentage:", 20, (0, 100, 1)),
    (PF_SLIDER, "stop_end", "Delete Stop End Percentage:", 80, (0, 100, 1)),
    ],
    [],
    tt_delete_svg_gradient_stop_range)
main()
