; This program is free software; you can redistribute it and/or modify
; it under the terms of the GNU General Public License as published by
; the Free Software Foundation; either version 2 of the License, or
; (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.

(define (script-fu-save-all-images inDir 
		  inSaveType 
		  inFileName 
		  inFileNumber) 
  (let* (
          (i (car (gimp-image-list)))
          (ii (car (gimp-image-list))) 
          (image)
          (newFileName "")
          (saveString "")
          (pathchar (if (equal? (substring gimp-dir 0 1) "/") "/" "\\"))
        )
    (set! saveString
      (cond 
        (( equal? inSaveType 0 ) ".jpg" )
        (( equal? inSaveType 1 ) ".bmp" )
        (( equal? inSaveType 2 ) ".png" )
        (( equal? inSaveType 3 ) ".tif" )
      )
    ) 
    (while (> i 0) 
      (set! image (vector-ref (cadr (gimp-image-list)) (- i 1)))
      (set! newFileName (string-append inDir 
              pathchar inFileName 
              (substring "00000" (string-length 
              (number->string (+ inFileNumber i))))
              (number->string (+ inFileNumber i)) saveString))
      (gimp-file-save RUN-NONINTERACTIVE 
                      image
                      (car (gimp-image-get-active-layer image))
                      newFileName
                      newFileName
      ) 
      (gimp-image-clean-all image) 
      (set! i (- i 1))
    )
  )
) 

(script-fu-register "script-fu-save-all-images" 
 "<Image>/File/Save ALL As" 
 "Save all opened images as ..." 
 "Lauchlin Wilkinson (& Saul Goode)" 
 "Lauchlin Wilkinson (& Saul Goode)" 
 "2014/04/21" 
 ""
 SF-DIRNAME    "Save Directory" ""
 SF-OPTION     "Save File Type" (list "jpg" "bmp" "png" "tif")
 SF-STRING     "Save File Base Name" "IMAGE"
 SF-ADJUSTMENT "Save File Start Number" (list 0 0 9000 1 100 0 SF-SPINNER)
 )