#!/usr/bin/env python

# fade_frames.py Release 1
# Created by Tin Tran http://gimplearn.net
#
# License: GPLv3
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY# without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# To view a copy of the GNU General Public License
# visit: http://www.gnu.org/licenses/gpl.html
#
# ------------
#| Change Log |
# ------------
# Rel 1: Initial release - based on plugins by Tin Tran:
# 		 Fade Frame Plug-in                                 https://gimplearn.net/viewtopic.php?f=3&t=2369&sid=cd6929e9f014606b69ce34aac81dc6f9
# 		 Slider Animation Script for GIMP (Swipe Animation) https://gimplearn.net/viewtopic.php?f=3&t=1037&hilit=slider
# 		 Rename Layers Script For Animated .gifs animation  https://gimplearn.net/viewtopic.php?f=3&t=72&p=4243&hilit=rename+layers#p4243

from gimpfu import *
import random
import math
import os
import string
from array import array

def python_fu_slideshow_frames(image, layer, style, frames, slider_width, prefix, delay, replace):
	pdb.gimp_image_undo_group_start(image)
	pdb.gimp_context_push()
	
	applylayers = []
	counter = 0
	if style==0 or style > 3:
		pdb.gimp_progress_init("exporting images...",None)
		fraction = 100.0/frames
		active = pdb.gimp_image_set_active_layer(image,layer)
		new_layer = pdb.gimp_layer_new_from_drawable(layer, image)
		pdb.gimp_image_insert_layer(image,new_layer,None,-1)
		pdb.gimp_item_set_visible(new_layer, 0)
		new_image = pdb.gimp_image_new(image.width, image.height, 0)
		display = pdb.gimp_display_new(new_image)
		start = pdb.gimp_layer_new_from_visible(image,new_image,"Fade_frames")
		pdb.gimp_image_insert_layer(new_image,start,None,0)
		for frame in range(0,int(frames)+1):
			opacity = frame * fraction
			pdb.gimp_progress_update(float(frame)/frames)
			pdb.gimp_layer_set_opacity(layer,opacity)
			
			if style==4:
				pdb.plug_in_cubism(new_image, layer, 10, 5, 0, run_mode=RUN_NONINTERACTIVE)
			if style==5:	
				pdb.plug_in_pixelize2(new_image, layer, 10, 10, run_mode=RUN_NONINTERACTIVE)
			if style==6:				
				pdb.plug_in_video(new_image, layer, 3, 1, 0, run_mode=RUN_NONINTERACTIVE)	

			visible = pdb.gimp_layer_new_from_visible(image,new_image,"Fade_frames")
			pdb.gimp_image_insert_layer(new_image,visible,None,0)
		pdb.gimp_item_set_visible(new_layer, 1)
		pdb.gimp_image_remove_layer(image, layer)
		pdb.gimp_image_raise_item_to_top(new_image, start)
	if style==1 or style==2 or style==3:
		new_image = pdb.gimp_image_duplicate(image)
		pdb.gimp_display_new(new_image)
		layers_count = len(new_image.layers)
		animate_layers = list(new_image.layers)
		for layer in animate_layers:
			if not layer.has_alpha:
				pdb.gimp_layer_add_alpha(layer)
		
		bottom_layer = pdb.gimp_layer_new_from_drawable(new_image.layers[0],new_image)
		pdb.gimp_image_insert_layer(new_image,bottom_layer,None,layers_count)
		if style == 1:
			if slider_width > 0:
				slider_layer = pdb.gimp_layer_new(new_image,slider_width,image.height,RGBA_IMAGE,"slider",100,NORMAL_MODE)
		elif style  == 2 or style == 3: #circle
			slider_layer = pdb.gimp_layer_new(new_image,image.width,image.height,RGBA_IMAGE,"slider",100,NORMAL_MODE)
		if slider_width > 0:	
			pdb.gimp_image_insert_layer(new_image,slider_layer,None,0)
		#pdb.gimp_context_set_foreground(slider_color)
			pdb.gimp_edit_fill(slider_layer,FOREGROUND_FILL)
		
		if style  == 1:
			start = -slider_width
			inc = float(image.width+slider_width)/frames
			#for i in range(0,len(animate_layers)):
			current_frame = animate_layers[0]
			for x in range(0,int(frames+1)):
				pdb.gimp_image_select_rectangle(new_image,CHANNEL_OP_REPLACE,0,0,min(image.width,max(0,x*inc)),image.height)
				non_empty,x1,y2,x2,y2 = pdb.gimp_selection_bounds(new_image)
				if non_empty:
					pdb.gimp_edit_clear(current_frame)
				if slider_width > 0:	
					pdb.gimp_layer_set_offsets(slider_layer,start + x*inc,0)
				frame_layer = pdb.gimp_layer_new_from_visible(new_image,new_image,"frame")
				pdb.gimp_image_insert_layer(new_image,frame_layer,None,0)
				frame_layer.visible = False
			pdb.gimp_image_remove_layer(new_image,bottom_layer)
			if slider_width > 0:
				pdb.gimp_image_remove_layer(new_image,slider_layer)
			for layer in animate_layers:
				pdb.gimp_image_remove_layer(new_image,layer)
			
			for layer in new_image.layers:
				layer.visible = True			
		if style  == 2 or style ==3:
			radius = ((image.width/2)**2 + (image.height/2)**2)**0.5
			start = -slider_width
			inc = float(radius+slider_width)/frames
			#for i in range(0,len(animate_layers)):
			current_frame = animate_layers[0]
			for x in range(0,int(frames+1)):
				pdb.gimp_selection_all(new_image)
				if slider_width > 0:
					pdb.gimp_edit_clear(slider_layer)
				if style  == 2:	
					pdb.gimp_image_select_rectangle(new_image,CHANNEL_OP_REPLACE,image.width/2-max(0,start+inc*x+slider_width),image.height/2-max(0,start+inc*x+slider_width),max(0,start+inc*x+slider_width)*2,max(0,start+inc*x+slider_width)*2)
					pdb.gimp_image_select_rectangle(new_image,CHANNEL_OP_SUBTRACT,image.width/2-max(0,start+inc*x),image.height/2-max(0,start+inc*x),max(0,start+inc*x)*2,max(0,start+inc*x)*2)					
					non_empty,x1,y2,x2,y2 = pdb.gimp_selection_bounds(new_image)				
				if style  == 3:	
					pdb.gimp_image_select_ellipse(new_image,CHANNEL_OP_REPLACE,image.width/2-max(0,start+inc*x+slider_width),image.height/2-max(0,start+inc*x+slider_width),max(0,start+inc*x+slider_width)*2,max(0,start+inc*x+slider_width)*2)
					pdb.gimp_image_select_ellipse(new_image,CHANNEL_OP_SUBTRACT,image.width/2-max(0,start+inc*x),image.height/2-max(0,start+inc*x),max(0,start+inc*x)*2,max(0,start+inc*x)*2)
					non_empty,x1,y2,x2,y2 = pdb.gimp_selection_bounds(new_image)
				if non_empty:
					pdb.gimp_edit_fill(slider_layer,FOREGROUND_FILL)
				if style  == 2:						
					pdb.gimp_image_select_rectangle(new_image,CHANNEL_OP_REPLACE,image.width/2-max(0,start+inc*x),image.height/2-max(0,start+inc*x),max(0,start+inc*x)*2,max(0,start+inc*x)*2)					
					non_empty,x1,y2,x2,y2 = pdb.gimp_selection_bounds(new_image)
				if style  == 3:					
					pdb.gimp_image_select_ellipse(new_image,CHANNEL_OP_REPLACE,image.width/2-max(0,start+inc*x),image.height/2-max(0,start+inc*x),max(0,start+inc*x)*2,max(0,start+inc*x)*2)
					non_empty,x1,y2,x2,y2 = pdb.gimp_selection_bounds(new_image)
				if non_empty:
					pdb.gimp_edit_clear(current_frame)

				frame_layer = pdb.gimp_layer_new_from_visible(new_image,new_image,"frame")
				pdb.gimp_image_insert_layer(new_image,frame_layer,None,0)
				frame_layer.visible = False

			pdb.gimp_image_remove_layer(new_image,bottom_layer)
			if slider_width > 0:
				pdb.gimp_image_remove_layer(new_image,slider_layer)
			for layer in animate_layers:
				pdb.gimp_image_remove_layer(new_image,layer)
			
			for layer in new_image.layers:
				layer.visible = True	
	
	applylayers = []
	counter = 0
	for layer in new_image.layers[::-1]:
		counter += 1
		applylayers.append([layer,counter])

	for applylayer in applylayers:
		applylayer[0].name = "Name"
		
	for applylayer in applylayers:
		layername = prefix + ' ' + str(applylayer[1]) + ' (' + str(int(delay)) + 'ms)'
		if replace == 1:
			layername = layername + ' (replace)'
		applylayer[0].name = layername
		if replace == 2:
			layername = layername + ' (combine)'
		applylayer[0].name = layername
		
	pdb.gimp_context_pop()
	pdb.gimp_image_undo_group_end(image)
	pdb.gimp_displays_flush()
	#return

register(
	"python_fu_slideshow_frames",                           
	"Transition from two layers in frames for slideshow: \nfrom TOP layer(active) to BOTTOM layer ",
	"Transition from 1 frame to another",
	"Tin Tran/MrQ",
	"GPL",
	"May 2019",
	"<Image>/Filters/Animation/Animators/Slideshow...",             #Menu path
	"RGB*, GRAY*", 
	[
	(PF_OPTION, "style", " Efect : ", 1, [" Fade "," Slider Bar "," Slider Rectangle "," Slider Circle "," Cubism+Fade "," Pixelize+Fade "," Video+Fade "]),
	(PF_SPINNER, "frames", " Number of Frames: ", 25, (2, 1000, 1)),
	(PF_SPINNER, "slider_width", " Slider Width:\n (Color = FG) ", 10, (0, 200, 1)),
	(PF_STRING, "prefix", " Layer Name Prefix: ", "Frame"),
	(PF_SPINNER, "delay", " Delay(ms): ", 100, (1, 10000, 10)),
	(PF_OPTION, "replace", " Disposal Type: ", 1, [" DON'T CARE\n (*.webp) "," REPLACE\n (*.gif) "," COMBINE\n (*.gif) "]), 
	],
	[],
	python_fu_slideshow_frames)

main()
